

function [D] = get_core_data(file_name)

% This funciton fetches the core data from an xlsx spreadsheet. 
% The indexing of the respective sample concentrations and errors etc is
% static so if you add samples, or change things about make sure everything
% matches!

% Data is returned in a struct (D) but not saved in this function

% read data in as a table
data_14C = readtable(file_name);

% get concentrations and uncerts for each borehole
D.BH02.n14_concs = table2array(data_14C([1:4],10));
D.BH02.dN14 = table2array(data_14C([1:4],11));
D.BH03.n14_concs = table2array(data_14C([5:8],10));
D.BH03.dN14 = table2array(data_14C([5:8],11));
D.BH06.n14_concs = table2array(data_14C(9,10));
D.BH06.dN14 = table2array(data_14C(9,11));

% get top and bottom depths
D.BH02.top_z = table2array(data_14C([1:4],8)); 
D.BH02.btm_z = table2array(data_14C([1:4],9)); 
D.BH03.top_z = table2array(data_14C([5:8],8)); 
D.BH03.btm_z = table2array(data_14C([5:8],9)); 
D.BH06.top_z = table2array(data_14C(9,9)); 
D.BH06.btm_z = table2array(data_14C(9,8)); 

% set ice elvs etc
D.BH02.ice_thickness = table2array(data_14C(1,6));
D.BH02.ice_surf_elv = table2array(data_14C(1,5));
D.BH02.surf_elv =  table2array(data_14C(1,7));
D.BH03.ice_thickness = table2array(data_14C(6,6));
D.BH03.ice_surf_elv = table2array(data_14C(6,5));
D.BH03.surf_elv =  table2array(data_14C(6,7));
D.BH06.ice_thickness = table2array(data_14C(9,6));
D.BH06.ice_surf_elv = table2array(data_14C(9,5));
D.BH06.surf_elv =  table2array(data_14C(9,7));

% save core_data